/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.output;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.state.EvaluationState;
import kickass.state.breakpoint.Breakpoint;
import kickass.state.breakpoint.Watchpoint;
import kickass.state.scope.ResolvedSymbol;

public class ViceSymbolFile {
    public void writeFile(String string, EvaluationState evaluationState) {
        try {
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream(string, false);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.writeSymbols(evaluationState.scopeMgr.getResolvedSymbols(), bufferedWriter);
            this.writeBreakpoints(evaluationState.breakpointMgr.getAllBreakpoints(), bufferedWriter);
            this.writeWatchpoints(evaluationState.breakpointMgr.getAllWatchpoints(), bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            evaluationState.log.error("IO error while writing vice symbol file '" + string + "':" + iOException.getMessage());
        }
        catch (Exception exception) {
            evaluationState.log.error("Internal error while writing vice symbol file '" + string + "'. Contact the author");
            exception.printStackTrace(System.out);
        }
    }

    private void writeSymbols(List<ResolvedSymbol> list, Writer writer) throws Exception {
        List<ResolvedSymbol> list2;
        String string;
        HashMap<String, ArrayList<ResolvedSymbol>> hashMap = new HashMap<String, ArrayList<ResolvedSymbol>>();
        for (ResolvedSymbol object : list) {
            string = object.name;
            if (string.startsWith("@")) {
                string = string.substring(1);
            }
            if ((list2 = (ArrayList<ResolvedSymbol>)hashMap.get(string)) == null) {
                list2 = new ArrayList<ResolvedSymbol>();
                hashMap.put(string, (ArrayList<ResolvedSymbol>)list2);
            }
            list2.add(object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            list2 = (List)entry.getValue();
            boolean bl = list2.size() > 1;
            int n = 0;
            for (ResolvedSymbol resolvedSymbol : list2) {
                String string2 = string;
                if (bl) {
                    string2 = string2 + "__" + n++;
                }
                String string3 = Integer.toHexString(resolvedSymbol.address);
                writer.write("al C:" + string3 + " ." + string2 + "\n");
            }
        }
    }

    private void writeBreakpoints(List<Breakpoint> list, Writer writer) throws Exception {
        for (Breakpoint breakpoint : list) {
            String string = breakpoint.argument;
            if (string == null) {
                string = "";
            }
            writer.write("break " + Integer.toHexString(breakpoint.address) + " " + string + "\n");
        }
    }

    private void writeWatchpoints(List<Watchpoint> list, Writer writer) throws Exception {
        for (Watchpoint watchpoint : list) {
            String string = Integer.toHexString(watchpoint.address1) + " ";
            String string2 = watchpoint.address2 == null ? "" : Integer.toHexString(watchpoint.address2) + " ";
            String string3 = watchpoint.argument == null ? "" : watchpoint.argument + " ";
            writer.write("watch " + string3 + string + string2 + "\n");
        }
    }
}

